---
type: index
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# 20.0.6 - Stability Diagnostics (index)

> Observational diagnostics of stability and recovery. Tie to anchors (ε, c, π/φ) and SVA (∇S, λV, ψA).

---

## Diagnostic Framework

| Diagnostic | Description | Key Test |
|------------|-------------|----------|
| [[Stability Margin (diagnostic)]] | Combined reserves | Multi-factor safety |
| [[Robustness (diagnostic)]] | Shock tolerance | Form retention |
| [[Resilience (diagnostic)]] | Recovery speed | Return time |
| [[Metastability (diagnostic)]] | Window stability | Drift risk |
| [[Brittleness (diagnostic)]] | Fragility level | Break point |
| [[Hysteresis (diagnostic)]] | Threshold gap | Switch stability |
| [[Basin of Attraction (diagnostic)]] | Convergence zone | Pull strength |
| [[Capacity Margin (diagnostic)]] | Load headroom | Peak handling |
| [[Resolution Margin (diagnostic)]] | Signal clarity | Detail risk |
| [[Phase Margin (diagnostic)]] | Sync reserve | Lock strength |
| [[Closure Strength (diagnostic)]] | Form integrity | Shape hold |
| [[Buffer Allocation Policy (diagnostic)]] | Resource rules | Share balance |
| [[Inertia (diagnostic)]] | Change resistance | Move effort |

Each diagnostic provides:
- Technical and humane test criteria
- Scale-dependent manifestations
- Stability behavior patterns
- Recovery conditions

---

## Core References

Primitives:
- [[Form]]
- [[Field]]
- [[Structure]]

Anchors:
- [[ε — Difference Resolution Quantum (constant)]]
- [[π — Closure Geometry Ratio (constant)]]
- [[e — Natural Transformation Rate (constant)]]
- [[φ — Asymmetric Stabilization Ratio (constant)]]
- [[c — Difference Propagation Limit (constant)]]

Modulators:
- [[∇S — Structure Differentiation Gradient (Sarkisian)]]
- [[λV — Void Resonance Threshold (Volozhina)]]
- [[ψA — Awareness Phase Coherence Anchor (Aiza)]]

Related Patterns:
- [[20.0.1 - Form Classifications (index)]]
- [[20.0.2 - Field Classifications (index)]]
- [[20.0.3 - Awareness Classifications (index)]]
- [[20.0.4 - Propagation Patterns (index)]]
- [[20.0.5 - Interaction Dynamics (index)]]